package simulator;
import tournament.*;
import fifaranking.*;
import java.util.concurrent.*;

public class SimpleMatchSimulator implements MatchSimulator
{
	private SimpleMatchSimulator()
	{
	}
	
	private static class SimpleMatchSimulatorHolder
	{
		private static final SimpleMatchSimulator instance = new SimpleMatchSimulator();
	}
	
	public static MatchSimulator getInstance()
	{
		return SimpleMatchSimulatorHolder.instance;
	}
	
	@Override
	public void simulate(Match match)
	{
		Team home = match.getHomeTeam().getTeam();
		Team away = match.getAwayTeam().getTeam();
		int homeRank = External.getRanking().getTeamsPosition(home);
		int awayRank = External.getRanking().getTeamsPosition(away);
		
		int threshold = 3;
		if(homeRank > awayRank) threshold = 2;
		
		int homeScore = 0, awayScore = 0;
		ThreadLocalRandom random = ThreadLocalRandom.current();
		for(int i=0; i<10; i++)
		{
			int rv = random.nextInt(0, 15);
			if(rv < 5)
			{
				if(rv < threshold) homeScore++;
				else awayScore++;
			}
		}
		match.playMatch(homeScore, awayScore);
	}
}