package tournament;
import fifaranking.*;
import simulator.*;
import java.io.*;
import java.util.*;

class Application
{
	public static void main(String[] args)
	{
		External.setRanking(StaticRanking.getInstance());
		External.setSimulator(SimpleMatchSimulator.getInstance());
		GroupManager manager = GroupManager.getInstance();
		String groupFileName = "examples/groups.txt";
		if(args.length > 0)
		{
			groupFileName = args[0];
		}
		
		try
		{
			File file = new File(groupFileName);
			Scanner sc = new Scanner(file);
			manager.init(sc);
			sc.close();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		
		Scanner in = new Scanner(System.in);
		boolean wantsToQuit = false;
		while(!wantsToQuit)
		{
			String command = in.next();
			String groupID;
			switch(command)
			{
				case "day":
					DateManager.getInstance().dayPassed(System.out);
					break;
				case "schedule":
					groupID = in.next();
					GroupManager.getInstance().printSchedule(groupID, System.out);
					break;
				case "results":
					groupID = in.next();
					GroupManager.getInstance().printResults(groupID, System.out);
					break;
				case "exit":
					wantsToQuit = true;
					break;
			}
		}
		
	}
}