package tournament;
import java.util.*;
import java.io.*;
import java.text.*;
import simulator.*;

class DateManager
{
	private Calendar currentDate;
	private Map<Calendar, ArrayList<Match> > scheduledMatches;
	
	private void setMidnight(Calendar c)
	{
		c.set(Calendar.HOUR_OF_DAY, 0);
		c.set(Calendar.MINUTE, 0);
		c.set(Calendar.SECOND, 0);
		c.set(Calendar.MILLISECOND, 0);
	}
	
	private DateManager()
	{
		currentDate = Calendar.getInstance();
		currentDate.set(Calendar.DAY_OF_MONTH, 1);
		currentDate.set(Calendar.MONTH, Calendar.JANUARY);
		currentDate.set(Calendar.YEAR, 2015);
		setMidnight(currentDate);
		scheduledMatches = new HashMap<Calendar, ArrayList<Match> >();
	}
	
	private static class DateManagerHolder
	{
		private static final DateManager instance = new DateManager();
	}
	
	public void registerMatch(Match match)
	{
		Calendar when = Calendar.getInstance();
		when.setTime(match.getDate());
		setMidnight(when);
		if(scheduledMatches.containsKey(when))
		{
			scheduledMatches.get(when).add(match);
		}
		else
		{
			ArrayList<Match> list = new ArrayList<Match>();
			list.add(match);
			scheduledMatches.put(when, list);
		}
	}
	
	public static DateManager getInstance()
	{
		return DateManagerHolder.instance;
	}
	
	public void dayPassed(PrintStream out)
	{
		DateFormat format = new SimpleDateFormat("dd MMM yyyy");
		out.println("Current date: " + format.format(currentDate.getTime()));
		if(scheduledMatches.containsKey(currentDate))
		{
			out.println("Matches played today:");
			for(Match match : scheduledMatches.get(currentDate))
			{
				External.getSimulator().simulate(match);
				out.println(match);
			}
		}
		currentDate.add(Calendar.DAY_OF_MONTH, 1);
		out.println("New date: " + format.format(currentDate.getTime()));
	}
}