package tournament;
import java.util.*;
import java.io.*;

public class GroupManager
{
	private TreeMap<String, Group> groupById;
	private ArrayList<ObserverRegistrationQuery> queries;
	
	public static class ObserverRegistrationQuery
	{
		private Observer observer;
		private String observableID;
		public ObserverRegistrationQuery(Observer o, String s)
		{
			observer = o;
			observableID = s;
		}
	}
	
	private GroupManager()
	{
	}
	
	public Group registerQuery(ObserverRegistrationQuery query)
	{
		queries.add(query);
		return groupById.get(query.observableID);
	}
	
	public Group getGroupByID(String id)
	{
		return groupById.get(id);
	}
	
	public void init(Scanner sc)
	{
		int numberOfGroups = sc.nextInt();
		groupById = new TreeMap<String, Group>();
		queries = new ArrayList<ObserverRegistrationQuery>();
		for(int i=0; i<numberOfGroups; i++)
		{
			String id = sc.next();
			Group group = Group.read(sc);
			groupById.put(id, group);
		}
		for(ObserverRegistrationQuery q : queries)
		{
			groupById.get(q.observableID).addObserver(q.observer);
		}
	}
	
	private static class GroupManagerHolder
	{
		private static final GroupManager instance = new GroupManager();
	}
	
	
	public void printSchedule(String groupID, PrintStream out)
	{
		if(!groupById.containsKey(groupID))
		{
			out.println("No such group: " + groupID);
			return;
		}
		out.println("Schedule of " + groupID);
		out.println("------------------------------");
		groupById.get(groupID).printSchedule(out);
	}
	
	public void printResults(String groupID, PrintStream out)
	{
		if(!groupById.containsKey(groupID))
		{
			out.println("No such group: " + groupID);
			return;
		}
		out.println("Results of " + groupID);
		out.println("------------------------------");
		groupById.get(groupID).printResults(out);
	}
	
	public static GroupManager getInstance()
	{
		return GroupManagerHolder.instance;
	}
}