package tournament;
import tournament.exception.UnplayedMatchException;
import java.util.*;
import java.text.*;

public class Match extends Observable implements Comparable<Match>
{
	private SlotFiller homeTeam, awayTeam;
	private boolean wasPlayed;
	private int homeTeamScore, awayTeamScore;
	private Date date;
	
	@Override
	public int compareTo(Match m)
	{
		return this.date.compareTo(m.date);
	}
	
	public Match(SlotFiller homeTeam, SlotFiller awayTeam, Date date)
	{
		this.homeTeam = homeTeam;
		this.awayTeam = awayTeam;
		this.date = date;
		wasPlayed = false;
		DateManager.getInstance().registerMatch(this);
	}
	
	public String toString()
	{
		DateFormat format = new SimpleDateFormat("dd MMM yyyy");
		String matchResult;
		if(wasPlayed)
		{
			matchResult = "" + homeTeamScore + " - " + awayTeamScore;
		}
		else
		{
			matchResult = "? - ?";
		}
		String homeString = String.format("%1$20s", homeTeam.toString());
		String awayString = String.format("%1$-20s", awayTeam.toString());
		return format.format(date) + ": " + homeString + " " + matchResult + " " + awayString;
	}
	
	public Date getDate()
	{
		return date;
	}
	
	public SlotFiller getHomeTeam()
	{
		return homeTeam;
	}
	
	public SlotFiller getAwayTeam()
	{
		return awayTeam;
	}
	
	public boolean wasPlayed()
	{
		return wasPlayed;
	}
	
	public void playMatch(int homeScore, int awayScore)
	{
		this.homeTeamScore = homeScore;
		this.awayTeamScore = awayScore;
		wasPlayed = true;
		setChanged();
		notifyObservers();
	}
	
	public int getHomeScore() throws UnplayedMatchException
	{
		if(!wasPlayed) throw new UnplayedMatchException();
		return homeTeamScore;
	}
	
	public int getAwayScore() throws UnplayedMatchException
	{
		if(!wasPlayed) throw new UnplayedMatchException();
		return awayTeamScore;
	}
}