package tournament;
import java.util.*;
import java.text.*;

abstract class MatchScheduler
{
	public static MatchScheduler read(Scanner sc)
	{
		String type = sc.next();
		String className = "tournament." + type + "Scheduler";
		try
		{
			Class<?> c = Class.forName(className);
			if(MatchScheduler.class.isAssignableFrom(c))
			{
				return (MatchScheduler)(c.getConstructor(Scanner.class).newInstance(sc));
			}
			else
			{
				System.err.println(className + " is not a valid match scheduler.");
			}
		}
		catch (Exception e)
		{
			System.err.println("Problem loading " + className + " as match scheduler.");
		}
		return null;
	}
	
	public abstract Date nextDate();
}

class AtDatesScheduler extends MatchScheduler
{
	ArrayList<Date> dates;
	int index;
	
	public AtDatesScheduler(Scanner sc)
	{
		int numberOfDates = sc.nextInt();
		sc.nextLine();
		dates = new ArrayList<Date>();
		index = 0;
		DateFormat formatter = new SimpleDateFormat("dd MMM yyyy");
		for(int i=0; i<numberOfDates; i++)
		{
			try
			{
				dates.add(formatter.parse(sc.nextLine()));
			}
			catch(Exception e)
			{
			}
		}
	}
	
	@Override
	public Date nextDate()
	{
		Date result = dates.get(index);
		index++;
		return result;
	}
}

class WeeklyScheduler extends MatchScheduler
{
	Date currentDate;
	
	public WeeklyScheduler(Scanner sc)
	{
		DateFormat formatter = new SimpleDateFormat("dd MMM yyyy");
		try
		{
			currentDate = formatter.parse(sc.nextLine());
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	
	@Override
	public Date nextDate()
	{
		Date result = (Date)currentDate.clone();
		currentDate.setTime(currentDate.getTime() + 7*24*3600*1000);
		return result;
	}
}