package tournament;
import java.util.*;
import java.io.*;
import tournament.tiebreak.*;
import tournament.exception.*;

class OldResultGroup extends Group
{
	private ArrayList<Team> allTeams;
	private ArrayList<Match> allMatches;
	private ArrayList<TieBreak> tiebreaks;
	private ArrayList<RankingEntry> myRanking;
	private ArrayList<String> groupIDs;
	
	private void fetchGroups()
	{
		allTeams = new ArrayList<Team>();
		allMatches = new ArrayList<Match>();
		for(String id : groupIDs)
		{
			Group g = GroupManager.getInstance().getGroupByID(id);
			allMatches.addAll(g.getMatches());
			allTeams.addAll(g.getTeams());
		}
	}
	
	public OldResultGroup()
	{
		super();
	}
	
	public OldResultGroup(Scanner sc)
	{
		super(sc);
		tiebreaks = new ArrayList<TieBreak>();
		groupIDs = new ArrayList<String>();
		
		int numberOfGroups = sc.nextInt();
		for(int i=0; i<numberOfGroups; i++)
		{
			groupIDs.add(sc.next());
		}
		int numberOfTieBreaks = sc.nextInt();
		for(int i=0; i<numberOfTieBreaks; i++)
		{
			tiebreaks.add(TieBreak.read(sc));
		}
		updateTeams();
	}
	
	@Override
	public Team getIthTeam(int i) throws UnfinishedGroupException
	{
		if(!hasFinished()) throw new UnfinishedGroupException();
		return myRanking.get(i-1).getTeam();
	}
	
	@Override
	protected void init()
	{
		super.init();
		fetchGroups();
		myRanking = new ArrayList<RankingEntry>();
		for(Team team : allTeams) myRanking.add(new RankingEntry(team));
		for(TieBreak tiebreak : tiebreaks)
		{
			tiebreak.recompute(myRanking, allMatches);
		}
		Collections.sort(myRanking);
		
		Set<Team> myTeams = new HashSet<Team>();
		for(SlotFiller filler : teams)
		{
			myTeams.add(filler.getTeam());
		}
		
		myRanking.removeIf(x -> !myTeams.contains(x.getTeam()));
		
		finish();
	}
	
	@Override public void printResults(PrintStream out)
	{
		if(!hasStarted())
		{
			out.println("This group has not started yet.");
			return;
		}
		for(int i=0; i<myRanking.size(); i++)
		{
			out.println("" + (i+1) + ". " + myRanking.get(i));
		}
	}

}