package tournament;
import tournament.exception.*;
import java.util.*;
import java.io.*;

class RandomDrawingGroup extends Group
{
	private ArrayList<Team> ranking;
	
	public RandomDrawingGroup()
	{
		super();
	}
	
	public RandomDrawingGroup(Scanner sc)
	{
		super(sc);
		updateTeams();
	}
	
	@Override
	public Team getIthTeam(int i) throws UnfinishedGroupException
	{
		if(!hasFinished()) throw new UnfinishedGroupException();
		return ranking.get(i-1);
	}
	
	@Override
	protected void init()
	{
		super.init();
		ranking = new ArrayList<Team>();
		for(SlotFiller filler : teams)
		{
			ranking.add(filler.getTeam());
		}
		Collections.shuffle(ranking);
		finish();
	}
	
	@Override public void printResults(PrintStream out)
	{
		if(!hasStarted())
		{
			out.println("This group has not started yet.");
			return;
		}
		for(int i=0; i<ranking.size(); i++)
		{
			out.println("" + (i+1) + ". " + ranking.get(i));
		}
	}
}