package tournament;
import tournament.exception.*;
import tournament.tiebreak.*;
import java.util.*;
import java.io.*;

class RoundRobinGroup extends Group
{
	private MatchScheduler scheduler;
	private ArrayList<TieBreak> tiebreaks;
	private ArrayList<RankingEntry> ranking;
	
	public RoundRobinGroup()
	{
		super();
	}
	
	protected void generateMatches()
	{
		for(int i=0; i<teams.size(); i++)
		{
			for(int j=i+1; j<teams.size(); j++)
			{
				addMatch(new Match(teams.get(i), teams.get(j), scheduler.nextDate()));
				addMatch(new Match(teams.get(j), teams.get(i), scheduler.nextDate()));
			}
		}
	}
	
	public RoundRobinGroup(Scanner sc)
	{
		super(sc);
		int numberOfTieBreaks = sc.nextInt();
		tiebreaks = new ArrayList<TieBreak>();
		for(int i=0; i<numberOfTieBreaks; i++)
		{
			TieBreak tiebreak = TieBreak.read(sc);
			tiebreaks.add(tiebreak);
		}
		
		scheduler = MatchScheduler.read(sc);
		generateMatches();
		updateTeams();
	}
	
	@Override
	public Team getIthTeam(int i) throws UnfinishedGroupException
	{
		if(!hasFinished()) throw new UnfinishedGroupException();
		return ranking.get(i-1).getTeam();
	}
	
	@Override
	protected void init()
	{
		super.init();
		recomputeRanking();
	}
	
	private void recomputeRanking()
	{
		ranking = new ArrayList<RankingEntry>();
		for(SlotFiller filler : teams)
		{
			ranking.add(new RankingEntry(filler.getTeam()));
		}
		for(int i=0; i<tiebreaks.size(); i++)
		{
			tiebreaks.get(i).recompute(ranking, matches);
		}
		Collections.sort(ranking);
	}
	
	@Override
	protected void updateMatches(Match m)
	{
		recomputeRanking();
		super.updateMatches(m);
	}
	
	@Override public void printResults(PrintStream out)
	{
		if(!hasStarted())
		{
			out.println("This group has not started yet.");
			return;
		}
		for(int i=0; i<ranking.size(); i++)
		{
			out.println("" + (i+1) + ". " + ranking.get(i));
		}
	}
}