package tournament;
import fifaranking.*;
import java.util.*;

public abstract class SlotFiller extends Observable
{
	private boolean ready;
	protected Team result;
	
	protected SlotFiller()
	{
		ready = false;
		result = null;
	}
	
	protected void finish()
	{
		ready = true;
		setChanged();
		notifyObservers();
	}
	
	public boolean isReady()
	{
		return ready;
	}
	
	public Team getTeam()
	{
		return result;
	}
	
	
	public static SlotFiller read(Scanner sc)
	{
		String type = sc.next();
		String className = "tournament." + type + "Filler";
		try
		{
			Class<?> c = Class.forName(className);
			if(SlotFiller.class.isAssignableFrom(c))
			{
				return (SlotFiller)(c.getConstructor(Scanner.class).newInstance(sc));
			}
			else
			{
				System.err.println(className + " is not a valid slot filler");
			}
		}
		catch (Exception e)
		{
			System.err.println("Problem loading " + className + " as slot filler.");
			e.printStackTrace();
		}
		return null;
	}
	
	@Override
	public String toString()
	{
		if(ready)
		{
			return result.toString();
		}
		return "To be decided";
	}
}

class FifaRankedFiller extends SlotFiller
{
	public FifaRankedFiller(Scanner sc)
	{
		super();
		int position = sc.nextInt();
		result = External.getRanking().getIthTeam(position);
		finish();
	}
}

class PlacedIthFiller extends SlotFiller implements Observer
{
	private int position;
	private String groupID;
	
	public PlacedIthFiller(Scanner sc)
	{
		super();
		position = sc.nextInt();
		groupID = sc.next();
		GroupManager.ObserverRegistrationQuery query;
		query = new GroupManager.ObserverRegistrationQuery(this, groupID);
		Group myGroup = GroupManager.getInstance().registerQuery(query);
		if(myGroup != null) updateGroup(myGroup);
	}
	
	private void updateGroup(Group g)
	{
		try
		{
			result = g.getIthTeam(position);
		}
		catch (Exception e)
		{
			return;
		}
		finish();
	}
	
	@Override
	public String toString()
	{
		if(isReady())
		{
			return result.toString();
		}
		return "Team #" + position + " from " + groupID;
	}
	
	
	@Override
	public void update(Observable o, Object arg)
	{
		if(!(o instanceof Group)) return;
		updateGroup((Group)(o));
	}
}
