package tournament.tiebreak;
import tournament.*;
import java.util.*;

public class RankingEntry implements Comparable<RankingEntry>
{
	private Team team;
	private ArrayList<TieBreak> myTieBreaks;
	
	public RankingEntry(Team team)
	{
		this.team = team;
		myTieBreaks = new ArrayList<TieBreak>();
	}
	
	public Team getTeam()
	{
		return team;
	}
	
	public int compareTo(RankingEntry other)
	{
		for(TieBreak tiebreak : myTieBreaks)
		{
			int res = tiebreak.compare(this.team, other.getTeam());
			if(res != 0)return res;
		}
		return 0;
	}
	
	public void addTieBreak(TieBreak tiebreak)
	{
		myTieBreaks.add(tiebreak);
	}
	
	@Override
	public String toString()
	{
		String result = team.toString();
		for(TieBreak tiebreak : myTieBreaks)
		{
			result = result + " | " + String.format("%1$20s", tiebreak.stringValue(team));
		}
		return result;
	}
}