#!/usr/bin/python3

import random
import time
import os
from game_state import *
from visualizer import *

"""The state of the game."""
gs = initial_state()

while True:
    print("\033[2J")
    paint(gs)
    print("\033[37;0m")
    if len(gs.ranking) == 4:
        break

    roll = random.randrange(1, 7)
    print("It is %splayer %d\033[37;0m\'s turn. You rolled %d."
          % (player_clr[gs.actor], gs.actor, roll))

    # See if there is any valid move. If there is not, skip this player.
    num_valid_moves = 0
    valid_move = -1
    for i in range(4):
        try:
            move_piece(i, roll, gs)
            num_valid_moves += 1
            valid_move = i
        except InvalidMoveException:
            pass
    if num_valid_moves == 0:
        print('Unfortunate, but you have no valid moves. Your turn is '
              'skipped.\n(Press ENTER to continue...)')
        input()
        gs = skip_turn(gs)
        continue
    elif num_valid_moves == 1:
        print('You have only one valid move, and that is moving '
              'piece %d.\n(Press ENTER to continue...)' % valid_move)
        gs = move_piece(valid_move, roll, gs)
        input()
        continue

    # There is more than one valid move! Let the player choose one.
    print("Which piece do you want to move?")
    while True:
        try:
            line = input().strip()
            pid = int(line)
        except ValueError:
            print('Pieces are represented by numbers from 0 to 3. \'%s\' is '
                  'not one of these.' % line)
            continue
        try:
            gs = move_piece(pid, roll, gs)
            break
        except InvalidMoveException:
            print('Invalid move. Choose again.')
        except IndexError:
            print('Pieces are represented by numbers from 0 to 3. \'%s\' is '
                  'not one of these.' % line)

print('Ranking:')
for i in range(4):
    print("%d. %splayer %d\033[37;0m"
          % (i + 1, player_clr[gs.ranking[i]], gs.ranking[i]))
