import cmd
from random import randint

"""hra[i][j] pre 0<=i<=3 a 0<=j<=3 oznacuje j-tu figurku i-teho hraca
hra[4] je index hraca prave na rade a hra[5] je momentalna hodnota kocky"""
hra = ((0, 0, 0, 0), (0, 0, 0, 0), (0, 0, 0, 0), (0, 0, 0, 0), 0, -1)


def vypis(kocka):
    """vypise stav hry, ak je nastavene kocka = True, vypise aj hodnotu kocky"""
    print('\nHrac', hra[4] + 1, 'je na tahu.')
    if kocka:
        print('Kocka:', hra[5])
    for i in range(4):
        print('Figurky hraca ', i + 1, ': ', end="", sep="")
        for j in range(4):
            print(j + 1, ':', hra[i][j], end=" ", sep="")
        print()


class ParseCommands(cmd.Cmd):
    """komunikacia s uzivatelom: caka na prikazy a vykonava ich"""
    intro = 'Vitaj v hre clovece nehnevaj sa. Najskor hod kockou. Pre pomoc ' \
            'napis \'help\''
    prompt = 'cakam prikaz: '

    def help_throw(self):
        print('throw\nHodi nahodne kockou a vypise stav hry. Ak sa hracovi '
              'nepaci kolko hodil, moze hodit znova.')

    def help_move(self):
        print('move <figurka>\nAk bola hodena kocka, posunie figurku cislo '
              '<figurka> patriacu hracovi ktory, je na tahu o pocet policok '
              'zodpovedajucich hodnote na kocke a vypise stav hry.')

    def help_bye(self):
        print('Vypne aplikaciu')

    def do_throw(self, args):
        global hra
        hra = tuple(randint(1, 6) if i == 5 else (True if i == 6 else nieco)
                    for i, nieco in enumerate(hra))
        vypis(True)

    def do_move(self, koho):
        global hra
        koho = int(koho)
        if (hra[5] == -1):
            print('Najskor hod kockou')
            return False
        if koho > 4 or koho < 1:
            print('Mozes posunut len panakov 1-4')
            return False
        print('Posuvam figurku', koho, 'o', hra[5])
        koho -= 1
        novyhrac = tuple((figurka + hra[5]) % 40 if i == koho else figurka
                         for i, figurka in enumerate(hra[hra[4]]))
        new_hra = []
        for i, nieco in enumerate(hra):
            if i == hra[4]:
                new_hra.append(novyhrac)
            elif i == 4:
                new_hra.append((hra[4] + 1) % 4)
            elif i == 5:
                new_hra.append(-1)
            else:
                new_hra.append(nieco)

        hra = tuple(new_hra)
        vypis(False)

    def do_bye(self, arg):
        print('Ahoj')
        return True


if __name__ == '__main__':
    vypis(False)
    ParseCommands().cmdloop()
