###Concurency
Here we analyse concurency issues. This is my third step to complete the homework.

Python dictionaries are threadsafe. Thus we can implement simple changes without issues. We just 
have to be carefull to do everything in single operation (and document it in the code, so somebody
that will maybe edit this in the future does not screw things up). The following operations, 
however, cannot be done in a single operation, so we need to take care.

* *removeOwner*: We have to check whether owner has no accounts and delete him atomically.
* *createAccount*, *changeAccountOwner*: We have to check whether the owner exists and 
    create account/change account owner atomically.
* *ownerAccounts*: We want get all accounts atomically.
* *transfer*: Of course, atomic change of amounts. And none of the accounts may be deleted.

###Solution
Supereasy solution is to have one lock for whole banking system. But that is no fun and
limits the ability of the system. So lets aim for something simple with high throughput.

We give each owner and Account a Lock. We give each Owner a Lock. Python collections are 
thread safe, so we do not need to worry about simple situations, however for adding and 
deleting elements it is necessary to lock the collection. Also for changing account owner,
as one needs to safely check if an owner has no account.

