import bank
import concurrent.futures
import dummy_transfer_analyzer
import time

with concurrent.futures.ThreadPoolExecutor(max_workers=5) as executor:
    a=dummy_transfer_analyzer.DummyTransferAnalyzer(1)
    b=bank.Bank(executor,a)
    exc=0; #the number of catched exceptions, i do not want to realy write an unit test :)

    owner1=b.createOwner("Rele")
    owner2=b.createOwner("Zuzka")
    owner3=b.createOwner("Zinka")
    assert b.ownerName(owner1)=="Rele"
    b.changeOwnerInfo(owner1, "Robko")
    assert b.ownerName(owner1)=="Robko"

    b.removeOwner(owner3)
    try:
        b.ownerName(owner3)
    except bank.BadOwnerId:
        exc+=1
    assert exc==1

    try:
        b.removeOwner(owner3)
    except bank.BadOwnerId:
        exc+=1
    assert exc==2

    account1=b.createAccount(owner1, 1000)
    try:
        b.removeOwner(owner1)
    except bank.OwnerHasAccount:
        exc+=1
    assert exc==3


    account2=b.createAccount(owner1, 500)
    account3=b.createAccount(owner1, 400)
    account4=b.createAccount(owner2, 600)  
    assert len(b.ownerAccounts(owner2))==1
    assert len(b.ownerAccounts(owner1))==3
    b.changeAccountOwner(account2, owner2)
    b.changeAccountOwner(account3, owner2)
    assert len(b.ownerAccounts(owner2))==3
    assert len(b.ownerAccounts(owner1))==1
    
    assert b.accountAmount(account2)==500
    try:
        b.removeOwner(owner1)
    except bank.OwnerHasAccount:
        exc+=1
    assert exc==4

    
    b.deleteAccount(account1)
    b.removeOwner(owner1)
    try:
        b.accountAmount(account1)
    except bank.BadAccountNumber:
        exc+=1
    assert exc==5

    
    f=b.transfer(account2, account3, 300)
    assert f.result()==bank.TransferResult.DONE
    assert b.accountAmount(account2)==200
    assert b.accountAmount(account3)==700

    try:
        f=b.transfer(account2, account3, 500)
    except bank.NotEnoughMoney:
        exc+=1
    assert exc==6

    f=b.transfer(account2, account3, 100)
    b.deleteAccount(account3)
    assert f.result()==bank.TransferResult.ERROR_ACCOUNT_DELETED
    assert b.accountAmount(account2)==200

    #Thanks to deep injection of analyzer we are even able to test the ERROR_NOT_ENOUGH_MONEY_PART
    #Still a bit hacky. But I do not want to create an elaborate mock.
    f=b.transfer(account2, account4, 150)
    time.sleep(0.1)
    #the previous transfer should be in the sleep phase now
    a.t=0.2
    f2=b.transfer(account2, account4, 200)
    #this should be faster
    assert f2.result()==bank.TransferResult.DONE
    assert b.accountAmount(account2)==0
    #now, the first transfer finishes
    assert f.result()==bank.TransferResult.ERROR_NOT_ENOUGH_MONEY
    assert b.accountAmount(account2)==0
    
    b.accounts.accounts[account2].amount=100   #hack
    assert f.result()==bank.TransferResult.ERROR_NOT_ENOUGH_MONEY


 

