###Bank
This is the public interface of a Bank class. As this is a homework, we do not know the needs 
of the client applications. But we can make a reasonable guess while still keeping things simple
enough. Note that this interface is the first part of the job that should be done (dependency 
inversion). Of course some changes and fixes later are possible (we definitely do not need to get 
this 100% correct), but they should NOT be based on implementation needs. 

As Python is a dynamic language, we do not have to care too much about interfaces. Doing the 
same in e.g. Java, we would define BankInterface containing the methods here. Note that I kept
the interfaces in my diagram. Even if they are not present in the language, they are important
concept to limit future changes impact. Also note, that in Python it is super easy to bypass
an interface. The programmer that e.g. needs to make a change in the Owner (see the analysis)
class can easily use a method of Account class not present in the interface. This is good for 
flexibility, but very bad for keeping firm subsystem boundaries.

This homework is much more complex than one expected to be submitted. There are several extras:
* account and owner deletion - Although, it seems easy it makes a lot of concurrency problems.
* separated bank into two classes - Not 100% necessary, but the smaller classes are nicer.
* more complex locking - Locking should be simple as it is hard to test, but if you lock
      too much with big locking scope, it can slow down the system a lot. This solution, while
      being relatively simple could handle a lot of requests; this is however hindered by Python's
      GIL, so the improvement is more or less academical, but if we used e.g. Jython, this might 
      make a huge difference. 
* documenting progress - There is a lot of extra documentation. For me, the interface, something
      describing the strategy of dealing with concurrency issues and the implementation would be 
      enough.

######Constructors
* *__init__(self, executor)*: Executor is to run workers evaluating suspicious transactions. 
Satisfies concurrent.futures.Executor interface. This allows the client to control the worker pool.

######Exceptions
* *class BankError(Exception)*: Base class for Bank system exception
* *class BadOwnerId(BankError)*: Thrown if owner_id is incorrect.
* *class BadAccountNumber(BankError)*: Thrown if account_number is incorrect.
* *class BadTransferId(BankError)*: Thrown if transfer_id is incorrect.
* *class OwnerHasAccount(BankError)*: Thrown if an owner requested to be deleted has an account.
* *class NotEnoughMoney(BankError)*: Thrown if an account has insufficient amount of money.

######Owner related stuff
* *createOwner(self, name)*: Returns its owner_id.
* *ownerName(self, owner_id)*: Throws BadOwnerId.
* *changeOwnerInfo(self, owner_id, new_name)*: Use this only if the name of the person changes 
      (e.g. after wedding). Throws BadOwnerId.
* *removeOwner(self, owner_id)*: Owner cannot have accounts. Throws BadOwnerId and OwnerHasAccount.

######Account related stuff
* *createAccount(self, owner_id, amount=0)*: Throws BadOwnerId. Amount is given in 1/10 cents.
      Returns account_number of the new account.
* *changeAccountOwner(self, account_number, owner_id)*: Throws BadOwnerId and BadAccountNumber.
* *deleteAccount(self, account_number)*: Throws BadAccountNumber.
* *ownerAccounts(self, owner_id)*: Returns a list of account_numbers. Throws BadOwnerId.
* *accountAmount(self, account_number)*: The amount on the account. Throws BadOwnerId.
* *transfer(self, account_number_from, account_number_to, amount)*: Amount is given in 1/10 cents.
      Returns concurrent.futures.Future object that returns TransferResult. Throws NotEnoughMoney,
      but only if insufficient funds are detected before the asynchronous checks. If the amount
      becomes insufficient while the checks are being done, the client will be notified via
      the future value. Note that as concurrent.futures.Future is really nice and it allows stuff
      like stopping the asynchronous checks.
* class TransferResult(Enum):
  - DONE
  - ERROR_NOT_ENOUGH_MONEY
      This is possible if during the checks by separate thread the amount of money decreased.
  - ERROR_ACCOUNT_DELETED
  - ERROR_SUSPICIOUS






