import threading
import misc
import bank

class Owners:
    def __init__(self):
        self.next_id=1
        self.owners={}
        self.lock=threading.RLock()

    def createOwner(self, name):
        with self.lock:
            o=misc.Owner(name)
            with o.lock:
                self.owners[self.next_id]=o
                i=self.next_id
                self.next_id+=1
        return i
        

    def owner(self, owner_id):
        try:
            #atomic read of owners[owner_id], no synchronisation necessary
            return self.owners[owner_id]
        except KeyError as exc:
            raise bank.BadOwnerId() from exc

    def changeOwnerInfo(self, owner_id, new_name):
        try:
            o=self.owners[owner_id]  #atomic
            with o.lock:
                if o!=self.owners[owner_id]:
                    raise bank.BadOwnerId() #owner was deleted inbetween
                o.name=new_name                
        except KeyError as exc:
            raise bank.BadOwnerId() from exc

    def removeOwner(self, owner_id, account_checker):
        try:
            o=self.owners[owner_id]  #atomic
            with o.lock:
                if o!=self.owners[owner_id]:
                    raise bank.BadOwnerId() #owner was deleted inbetween
                l=account_checker.getLock()
                with l:
                    if account_checker.ownerAccounts(owner_id):
                        raise bank.OwnerHasAccount()
                    self.owners.pop(owner_id)                
        except KeyError as exc:
            raise bank.BadOwnerId() from exc

