import unittest
from unittest.mock import Mock

#Functional style ranking function:
#result = rank_function(teams, matches)
#teams - tuple of teams to rank. Team has a.name property + whatever ranking functions require
#matches - tuple of matches. Has .home.name for home team name and .away.name and can swap sides 
#          + whatever ranking functions require
#result - tuple of tuples of strings(team names)

#Specific rank_functions:
#compose_rank_functions(f1, f2)
#rank_by_compress_fuction(function) 
#rank_by_away_goals
#recursive_ranking

class TestComposeRankFunctions(unittest.TestCase):    
    def setUp(self):
        self.teams=("Slovakia", "Germany", "France", "San Marino") #BTW repeated string constants may be evil
        self.matches=()
        self.function1 = Mock()
        self.function2 = Mock()

    def test_upper(self):
        self.function1.return_value = (("Slovakia", "Germany", "France"), ("San Marino",)) 
        self.function2.return_value = (("Germany", "France"), ("Slovakia", "San Marino")) 
        res = compose_rank_functions(self.function1, self.function2)(self.teams, self.matches)
        self.assertEqual(res, (("Germany", "France"), ("Slovakia",), ("San Marino"))
        #+may be if you are real mockist
        #self.function1.assert_called_once_with
        #self.function2.assert_called_once_with
        #but does this not cuple tests to implementation too much?

if __name__ == '__main__':
    unittest.main()
