#include "ranking.hpp"
#include <cassert>

using StubMatch = struct {std::string teams[2]; int goals[2];};
using StubTeam = std::string;

class StubFifaRanking {    
public:
    int get_rank(const StubTeam &team) const {
        if (team=="Germany") return 1;
        if (team=="France") return 3;
        if (team=="England") return 5;
        if (team=="Slovakia") return 30;
        if (team=="San Marino") return 200;
        return 201;
    }
};



int main() {
    StubFifaRanking fifa_ranking;

    std::vector<StubTeam> teams;
    std::vector<StubMatch> matches;
    matches.emplace_back(StubMatch({{"England", "France"}, {1, 1}}));
    matches.emplace_back(StubMatch({{"Germany", "England"}, {1, 1}}));
    matches.emplace_back(StubMatch({{"Slovakia", "France"}, {2, 2}}));
    matches.emplace_back(StubMatch({{"Germany", "Slovakia"}, {1, 1}}));
    matches.emplace_back(StubMatch({{"San Marino", "France"}, {0, 5}}));
    matches.emplace_back(StubMatch({{"Slovakia", "San Marino"}, {7, 0}}));
    matches.emplace_back(StubMatch({{"Germany", "San Marino"}, {6, 0}}));
    matches.emplace_back(StubMatch({{"England", "San Marino"}, {6, 0}}));


    teams = {"France", "England", "Slovakia", "San Marino", "Germany"};
    auto rule1 = FifaRankingRule(fifa_ranking);
    rule1.rank(teams.begin(), teams.end(), matches);
    assert(teams[0]=="Germany");
    assert(teams[1]=="France");
    assert(teams[2]=="England");
    assert(teams[3]=="Slovakia");
    assert(teams[4]=="San Marino");

    teams = {"France", "England", "Slovakia", "San Marino", "Germany"};
    auto rule2=(AccumulateRule(GoalsScoredAccumulator()));
    rule2.rank(teams.begin(), teams.end(), matches);
    assert(teams[0]=="Slovakia");
    assert(teams[1]=="France");
    assert(teams[2]=="England");
    assert(teams[3]=="Germany");
    assert(teams[4]=="San Marino");

    teams = {"France", "England", "Slovakia", "San Marino", "Germany"};
    auto rule3=(AccumulateRule(GoalDifferenceAccumulator()), FifaRankingRule(fifa_ranking));
    rule3.rank(teams.begin(), teams.end(), matches);
    assert(teams[0]=="Slovakia");
    assert(teams[1]=="Germany");
    assert(teams[2]=="England");
    assert(teams[3]=="France");
    assert(teams[4]=="San Marino");

   
    
    auto recursive_rule=RecursiveRule(AccumulateRule(PointsAccumulator()),
                                      AccumulateRule(GoalDifferenceAccumulator()),
                                      AccumulateRule(GoalsScoredAccumulator())); 
    auto rule=(recursive_rule, FifaRankingRule(fifa_ranking));
   
    rule.rank(teams.begin(), teams.end(), matches);

    assert(teams[0]=="Slovakia");
    assert(teams[1]=="France");
    assert(teams[2]=="Germany");
    assert(teams[3]=="England");
    assert(teams[4]=="San Marino");


}
