#include<optional>
#include<memory>
#include<iostream>

template<typename T>
class LinkedListPair;

template<typename T>
class LinkedList: public std::shared_ptr<LinkedListPair<T>>
{
public:
    LinkedList() {};
    LinkedList(T value, LinkedList<T> list);
    
    template<typename V, typename F> //requires Callable<V, LinkedList<T> -> V> 
    V apply(V value, F function);
};

template<typename T>
class LinkedListPair: public std::pair<T, LinkedList<T>> {
public:
   LinkedListPair(T value, LinkedList<T> list): std::pair<T, LinkedList<T>>(value, list) {}
};


template<typename T>
LinkedList<T>::LinkedList(T value, LinkedList<T> list): 
    std::shared_ptr<LinkedListPair<T>>(new LinkedListPair<T>(value, list)) {}


LinkedList<int> range(int from, int to, int step) {
    if (from == to || (from > to && step > 0) || (from < to && step < 0)) return {};
    return LinkedList<int>(from, range(from + step, to, step));
}

LinkedList<int> range(int cnt) {
    if (cnt == 0) return {};
    return range(cnt, 0, -1);
}

int sum1(LinkedList<int> list) {
    if (list) {
        auto p = list.get();
        return p->first+sum1(p->second);
    }
    return 0;
}


template<typename T>
template<typename V, typename F> 
V LinkedList<T>::apply(V value, F function) {
    if (*this) {
        auto p = this->get();
        return function(p->first, p->second);
    }
    return value;
}

int sum2(int first, LinkedList<int> rest) {
    return first + rest.apply(0, sum2);
}

LinkedList<int> copy(int first, LinkedList<int> rest) {
    return LinkedList<int>(first, 
           LinkedList<int>(first, 
                           rest.apply(LinkedList<int>(), copy)));
}




int main() {
    LinkedList<int> l1{};
    LinkedList<int> l2 = l1;
    LinkedList<int> l3 {1, l2};
    LinkedList<int> l4 {2, l3};
    LinkedList<int> l5 = range(5);
    std::cout << sum1(l5) <<"\n";
    std::cout << l5.apply(0,sum2) <<"\n";
    LinkedList<int> l6 = l5.apply(LinkedList<int>(), copy);
    std::cout << l6.apply(0,sum2) <<"\n";
  
    
    return 0;
}
