from collections import namedtuple
from datetime import timedelta
from position_rank import Rank

#Structures to decrease number of parameters / returned values
GroupInfo = namedtuple("GroupInfo", "name zone phase end_day")
GroupState = namedtuple("GroupState", "name zone phase standings") #standings - see .group_state

class PlayGroup(object):
    """
    PlayGroup takes care of group life cycle. It decides when matches are played, and using
    ranikng. It creates Rank objects and bijectively maps them into Position objects.

    PlayGroup class has following colaborators and uses following interfaces to comunicate:

    Team:
        .name - readonly

    Position, FilledPosition:
        .team - readonly, Gets Tam object or None

    Rank:
        Rank(...) - it is ok to create rank instances as we plan to test Sociable with Rank
        .position - Position object
        .is_final() 
        .make_final()

    Match:
        .play() - match is played .data changes from None to something
        .position1 - readonly, position of the first team
        .position2 - readonly, position of the second team
        .date - readonly, when match should be played 
        .data - readonly, we do not care what is it, it has to meet Ranking object's requirements.

    Ranking:
        .info_strings - readonly, list of strings, what standings data is produced by ranking.
        .rank(teams, matches) - 
            teams - list of team names, e.g. ["Slovakia", "Germany"]
            matches - list of Match .data objects, whatever they contain
            returns - list of pairs, first element in pair is the index in teams list second
                      element is a map that assigns a value to each string from .info_strings,
                      e.g. ((1, {goals: 1}), (0, {goals: 0})) means Germany is first and scored
                      one goal, slovakia is second and scored no goals
    """    
    def __init__(self, current_date, info, positions, ranking, matches)
        """    
        There is a lot to inject here:
            current_date - date object
            info - GroupInfo tuple
            positions - tupple of Position objects
            ranking - Ranking object
            matches - tupple of Match onjects
        """    

    def next_day(self):
        """    
        It plays matches that should be played on current day. If a match should be played and 
        some team is unknown, throw AssertionError. If the date is endday it sets Ranks as 
        final. Increments current day by one. 
        """    
        pass

    @property
    def standings_entries(self):
        """    
        This just forwards what information can ranking provide
        """    
        return self._ranking.info_strings

    def group_state(self, standings_entries):
        """
        Returns group state. 

        standings_entries - list of strings from self.standings_entries
        returns - GroupState tuple. Standings is a list ordered according to ranking of pairs 
            (teamname, map), where map contains keys from standings_entries. If a team is not known,
            teamname is "???". Example standing object when standing_entries is "(goals, points)":
                (("Slovakia", {"goals":1, "points":3}), ("Germany", {"goals":0, "points":0}), 
                 ("???", {"goals":0, "points":0})
                )
        """    
        pass

    @property
    def today_matches(self):
        """    
        Returns tople of pairs, that for each match contains both team names, if a team is unknown,
        team name is "???". E.g. (("Slovakia", "Germany"), ("France", "???"))
        """    
        pass

    def rank(self, i):
        """    
        Returns i-th Rank object
        """    
        pass
