from game import Player, Players

class PersistentPlayer(Player):
    def __init__(self, name, posX, posY, level, modified):
        self._modified = modified
        super().__init__(name, posX, posY, level)

    def left(self):
        self._modified.add(self._name)
        super().left()

    def right(self):
        self._modified.add(self._name)
        super().right()

    def up(self):
        self._modified.add(self._name)
        super().up()

    def down(self):
        self._modified.add(self._name)
        super().down()


#function that returns a factory that tracks newly created players
def get_player_factory(created):
    def player_factory(name, posx, posy, level):
        nonlocal created
        created.add(name)
        return Player(name, posx, posy, level)
    return player_factory


class PersistentPlayers:
    def __init__(self, connection_factory): #I see no reason to inject Player objects, but ability to mock connections may be importatnt
        self._connection_factory = connection_factory

    def _read_data(self):
        self._connection = self._connection_factory()
        self._cursor = self._connection.cursor()
        self._modified = set()
        self._created = set()
        player_list = []
        for row in self._cursor.execute("""SELECT name, posx, posy, level FROM players"""):
            player_list.append(PersistentPlayer(row[0], row[1], row[2], row[3], self._modified))
        self._players = Players(player_list, get_player_factory(self._created))

    def player(self, name):
        return self._players.player(name)
    
    def players(self):
        return self._players.players()

    def go(self, name):
        self._read_data() #you might not read everithing... but this is OK for us
        self._players.go(name)
        self._commit()
            
    def left(self, name):
        self._read_data()
        self._players.left(name)
        self._commit()

    def right(self, name):
        self._read_data()
        self._players.right(name)
        self._commit()

    def up(self, name):
        self._read_data()
        self._players.up(name)
        self._commit()

    def down(self, name):
        self._read_data()
        self._players.down(name)
        self._commit()
            
    def _commit(self):
        for name in self._created:
            player = self._players.player(name)
            self._cursor.execute("""INSERT INTO players (name, posx, posy, level) VALUES (?, ?, ?, ?)""", 
                                 (name, player.posX, player.posY, player.level))
        for name in self._modified.difference(self._created):
            player = self._players.player(name)
            self._cursor.execute("""UPDATE players SET posx = ?, posy = ?, level = ? WHERE name = ?""", 
                                 (player.posX, player.posY, player.level, name))
        self._connection.commit()            
        self._connection.close()

