#we have various collections
for element in [1, 2, 3]:
    print(element)

for element in (1, 2, 3):
    print(element)

for key in {'one':1, 'two':2}:
    print(key)

for char in "123":
    print(char)


"abc"[2]
{'one':1, 'two':2}['one']
(1, 2, 3)[1]
[1, 2, 3][1]

#btw this is not a list
(1)
#but this is
(1,)


#some collections are mutable
{'one':1, 'two':2}['one']=3
[1, 2, 3][1]=3


#some some are not
"abc"[2]='d'
(1, 2, 3)[1]=3


#mutability is actualy a big thing

#we may concatenate 
[1, 2, 3]+[4, 5]
(1, 2, 3)+(4,5)
"abc"+'de'

#and by combining all the stuff we can make very complex structure
{1:[{'name':'Jozo', 'id':1234}, {'name':'Fero', 'id':1235}], 2:[]}

#it is easy to create some lists
for i in range(3):
  print(i)

#but care range is a range object
range(3)
list(range(3))



#ok, list comprehensions now
[x**2 for x in range(5)]
[x for x in [1,2,3,5,7,9] if x in [2,3,5,6,7,8]]
[(x,y) for x in [1,2,3,5,7,9] for y in [1, 2]]

#or we can apply function
def sqr(i):
  return i*i

list(map(sqr, range(5)))

#btw note that this is not calculated, it is a range object
map(sqr, range(5))


#and we can use anonymous functions
list(map(lambda x: x**2, range(10)))


#two other common tools are filter and reduce, partial
list(filter(lambda x: x%2==0, map(lambda x: x**2, range(10))))
#hard to read?
iseven = lambda x: x%2==0
square = lambda x: x**2
list(filter(iseven, map(square, range(10))))


from functools import reduce, partial
reduce(lambda x,y: x*y, map(sqr, range(1,50)))
f2=partial(lambda x,y: x/y,2)
f2(8)

#what if we want to fix the second paramether and we dont want to mess with the function?
f2=partial(lambda x,y: (lambda x,y: x/y)(y,x),2)
f2(8)







