from game import WIDTH, HEIGHT
from urllib.parse  import urlparse, parse_qs
from http.server  import BaseHTTPRequestHandler

def getHandler(players_factory):
    class MyHandler(BaseHTTPRequestHandler):    
        def start(self):
            return """\
<HTML><BODY>
"""

        def end(self):
            return """\
</BODY></HTML>
"""

        def write_your_name(self):
            return """\
<form action="/go" method="get">
Name: <input type="text" name="name"> <input type="submit" value="Submit"><BR>
</form>
"""

        def world(self):
            strings = [["  " for _ in range(WIDTH)] for _ in range(HEIGHT)]
            for player in self._players.players(): 
                strings[player.posY][player.posX] = ("%02d" % player.level)
            strings = ["|"+"".join(string)+"|\n" for string in strings]
            strings.append(("-"*(2*WIDTH+2))+"</pre><BR>")
            strings.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<A HREF="
                           + self._root+"/up?name="+self._name+">Up</A><BR>")
            strings.append("<A HREF="+self._root+"/left?name="+self._name+">Left</A>")
            strings.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<A HREF="
                           + self._root+"/right?name="+self._name+">Right</A><BR>")
            strings.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<A HREF="
                           + self._root+"/down?name="+self._name+">Down</A><BR>")
            return "<pre>"+("-"*(2*WIDTH+2))+"\n"+"".join(strings)

        def _set_headers(self):
            self.send_response(200)
            self.send_header('Content-type', 'text/html')
            self.end_headers()

        def do_GET(self):
            #parse query
            parsed = urlparse(self.path)
            pquery = parse_qs(parsed.query)
            self._root = '..'
            self._name = pquery.get('name', (None,))[0]

            #start writing response headers
            self._set_headers()
            response = self.start()
            if parsed.path == '/':            
                self._root = ''
                response += self.write_your_name()        
    
            if self._name is not None:
                #we need to comunicate with db. we read the state ... this starts a transaction
                self._players = players_factory()
                if parsed.path == '/go':
                    self._players.go(self._name)
                    response += self.world()
                    response += "<BR>I start.<BR>"
                if parsed.path == '/left':
                    self._players.left(self._name)
                    response += self.world()
                    response += "<BR>I go left.<BR>"
                if parsed.path == '/up':
                    self._players.up(self._name)
                    response += self.world()
                    response += "<BR>I go left.<BR>"
                if parsed.path == '/down':
                    self._players.down(self._name)
                    response += self.world()
                    response += "<BR>I go left.<BR>"
                if parsed.path == '/right':
                    self._players.right(self._name)
                    response += self.world()
                    response += "<BR>I go right.<BR>"
            response += self.end()
            self.wfile.write(bytes(response, "UTF-8"))

        def do_POST(self):
            self.do_GET()

        def do_HEAD(self):
            self._set_headers()

    return MyHandler


