from game_http import getHandler
from game_sqlite import PersistentPlayers
from http.server  import HTTPServer
import sqlite3

HOST, PORT = "localhost", 80

def players_factory():
    def connect():
        return sqlite3.connect('game.db')
    return PersistentPlayers(connect)

server = HTTPServer((HOST, PORT), getHandler(players_factory))
try:
    server.serve_forever()
except KeyboardInterrupt:
    pass
server.server_close()



