from datetime import date

from team.team import Team, Teams
from match_simulator.match_simulator import MatchSimulator
from tournament.team import Team as GroupTeam
from tournament.playgroup import PlayGroup, GroupInfo
from tournament.match import Match
from tournament.ranking import Ranking
from tournament.position_rank import Position, FilledPosition, Rank

#create teams
team_slovakia = Team("Slovakia", 7, 7)
team_finland = Team("Finland", 8, 8)
team_germany = Team("Germany", 5, 7)
team_canada = Team("Canada", 10, 9)
team_us = Team("United States", 9, 8)
team_denmark = Team("Denmark", 5, 5)
team_france = Team("France", 4, 4)
team_uk = Team("United Kingdom", 3, 3)

team_switzerland = Team("Switzerland", 6, 7)
team_czechia = Team("Czech Republic", 8, 8)
team_russia = Team("Russia", 10, 8)
team_sweden = Team("Sweden", 10, 9)
team_latvia = Team("Latvia", 5, 7)
team_norway = Team("Norway", 6, 6)
team_austria = Team("Austria", 4, 5)
team_italy = Team("Italy", 3, 3)

teams = Teams([team_slovakia, team_finland, team_germany, team_canada, team_us,
               team_denmark, team_france, team_uk, team_switzerland, team_czechia,
               team_russia, team_sweden, team_latvia, team_norway, team_austria,
               team_italy])


#initialize matchsimulator
sim = MatchSimulator(teams)


#initialize groups
start_date = date(2019, 5, 9)

#GROUP A
slovakia = FilledPosition(GroupTeam("Slovakia"))
finland = FilledPosition(GroupTeam("Finland"))
germany = FilledPosition(GroupTeam("Germany"))
canada = FilledPosition(GroupTeam("Canada"))
us = FilledPosition(GroupTeam("United States"))
denmark = FilledPosition(GroupTeam("Denmark"))
france = FilledPosition(GroupTeam("France"))
uk = FilledPosition(GroupTeam("United Kingdom"))

matchesA = (Match(finland, canada, date(2019, 5, 10), sim),
            Match(us, slovakia, date(2019, 5, 10), sim),
            Match(denmark, france, date(2019, 5, 11), sim),
            Match(germany, uk, date(2019, 5, 11), sim),
            Match(slovakia, finland, date(2019, 5, 11), sim),
            Match(us, france, date(2019, 5, 12), sim),
            Match(denmark, germany, date(2019, 5, 12), sim),
            Match(uk, canada, date(2019, 5, 12), sim),
            Match(us, finland, date(2019, 5, 13), sim),
            Match(slovakia, canada, date(2019, 5, 13), sim),
            Match(uk, denmark, date(2019, 5, 14), sim),
            Match(germany, france, date(2019, 5, 14), sim),
            Match(us, uk, date(2019, 5, 15), sim),
            Match(germany, slovakia, date(2019, 5, 15), sim),
            Match(canada, france, date(2019, 5, 16), sim),
            Match(finland, denmark, date(2019, 5, 16), sim),
            Match(france, slovakia, date(2019, 5, 17), sim),
            Match(finland, uk, date(2019, 5, 17), sim),
            Match(denmark, us, date(2019, 5, 18), sim),
            Match(canada, germany, date(2019, 5, 18), sim),
            Match(uk, slovakia, date(2019, 5, 18), sim),
            Match(germany, us, date(2019, 5, 19), sim),
            Match(france, finland, date(2019, 5, 19), sim),
            Match(france, uk, date(2019, 5, 20), sim),
            Match(canada, denmark, date(2019, 5, 20), sim),
            Match(finland, germany, date(2019, 5, 21), sim),
            Match(slovakia, denmark, date(2019, 5, 21), sim),
            Match(canada, us, date(2019, 5, 21), sim))

groupA = PlayGroup(start_date, GroupInfo("Group A", None, None, date(2019, 5, 21)), (slovakia, finland, germany, canada, us, denmark, france, uk), Ranking(), matchesA)



#GROUP B
switzerland = FilledPosition(GroupTeam("Switzerland"))
czech = FilledPosition(GroupTeam("Czech Republic"))
russia = FilledPosition(GroupTeam("Russia"))
sweden = FilledPosition(GroupTeam("Sweden"))
latvia = FilledPosition(GroupTeam("Latvia"))
norway = FilledPosition(GroupTeam("Norway"))
austria = FilledPosition(GroupTeam("Austria"))
italy = FilledPosition(GroupTeam("Italy"))

matchesB = (Match(russia, norway, date(2019, 5, 10), sim),
            Match(czech, sweden, date(2019, 5, 10), sim),
            Match(switzerland, italy, date(2019, 5, 11), sim),
            Match(latvia, austria, date(2019, 5, 11), sim),
            Match(norway, czech, date(2019, 5, 11), sim),
            Match(russia, austria, date(2019, 5, 12), sim),
            Match(italy, sweden, date(2019, 5, 12), sim),
            Match(latvia, switzerland, date(2019, 5, 12), sim),
            Match(russia, czech, date(2019, 5, 13), sim),
            Match(norway, sweden, date(2019, 5, 13), sim),
            Match(italy, latvia, date(2019, 5, 14), sim),
            Match(switzerland, austria, date(2019, 5, 14), sim),
            Match(switzerland, norway, date(2019, 5, 15), sim),
            Match(russia, italy, date(2019, 5, 15), sim),
            Match(sweden, austria, date(2019, 5, 16), sim),
            Match(czech, latvia, date(2019, 5, 16), sim),
            Match(austria, norway, date(2019, 5, 17), sim),
            Match(czech, italy, date(2019, 5, 17), sim),
            Match(latvia, russia, date(2019, 5, 18), sim),
            Match(italy, norway, date(2019, 5, 18), sim),
            Match(sweden, switzerland, date(2019, 5, 18), sim),
            Match(austria, czech, date(2019, 5, 19), sim),
            Match(switzerland, russia, date(2019, 5, 19), sim),
            Match(sweden, latvia, date(2019, 5, 20), sim),
            Match(austria, italy, date(2019, 5, 20), sim),
            Match(czech, switzerland, date(2019, 5, 21), sim),
            Match(norway, latvia, date(2019, 5, 21), sim),
            Match(sweden, russia, date(2019, 5, 21), sim))

groupB = PlayGroup(start_date, GroupInfo("Group B", None, None, date(2019, 5, 21)), (switzerland, czech, russia, sweden, latvia, norway, austria, italy), Ranking(), matchesB)


pA1, pA2, pA3, pA4 = [Position(groupA.rank(i)) for i in range(4)]
pB1, pB2, pB3, pB4 = [Position(groupB.rank(i)) for i in range(4)]

QF1 = PlayGroup(start_date, GroupInfo("Quaterfinal 1", None, None, date(2019, 5, 23)), (pA1, pB4), Ranking(), (Match(pA1, pB4, date(2019, 5, 23), sim),))
QF2 = PlayGroup(start_date, GroupInfo("Quaterfinal 2", None, None, date(2019, 5, 23)), (pB2, pA3), Ranking(), (Match(pB2, pA3, date(2019, 5, 23), sim),))
QF3 = PlayGroup(start_date, GroupInfo("Quaterfinal 3", None, None, date(2019, 5, 24)), (pB1, pA4), Ranking(), (Match(pB1, pA4, date(2019, 5, 24), sim),))
QF4 = PlayGroup(start_date, GroupInfo("Quaterfinal 4", None, None, date(2019, 5, 24)), (pA2, pB3), Ranking(), (Match(pA2, pB3, date(2019, 5, 24), sim),))

pQ1 = Position(QF1.rank(0))
pQ2 = Position(QF2.rank(0))
pQ3 = Position(QF3.rank(0))
pQ4 = Position(QF4.rank(0))

SF1 = PlayGroup(start_date, GroupInfo("Semifinal 1", None, None, date(2019, 5, 25)), (pQ1, pQ2), Ranking(), (Match(pQ1, pQ2, date(2019, 5, 25), sim),))
SF2 = PlayGroup(start_date, GroupInfo("Semifinal 2", None, None, date(2019, 5, 25)), (pQ3, pQ4), Ranking(), (Match(pQ3, pQ4, date(2019, 5, 25), sim),))

pS1 = Position(SF1.rank(0))
pS2 = Position(SF2.rank(0))
pS3 = Position(SF1.rank(1))
pS4 = Position(SF2.rank(1))

Bronze = PlayGroup(start_date, GroupInfo("Bronze Medal Game", None, None, date(2019, 5, 26)), (pS3, pS4), Ranking(), (Match(pS3, pS4, date(2019, 5, 26), sim),))
Final= PlayGroup(start_date, GroupInfo("Final", None, None, date(2019, 5, 26)), (pS1, pS2), Ranking(), (Match(pS1, pS2, date(2019, 5, 26), sim),))

def next_day():
    groupA.next_day()
    groupB.next_day()
    QF1.next_day()
    QF2.next_day()
    QF3.next_day()
    QF4.next_day()
    SF1.next_day()
    SF2.next_day()
    Bronze.next_day()
    Final.next_day()



##Zaciname##
##9. 5.
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()
next_day()

def printstate(group):
    state = group.group_state(Ranking().info_strings)
    print(state.name)
    standings = {x[0]: x[1] for x in state.standings}    
    for i in range(8):
        team = group.rank(i).position.team.name
        print("%20s %d %d %d %d %d %2d:%2d %2d" % (team, standings[team]["matches"], standings[team]["wins"], standings[team]["overtime wins"], 
                                                   standings[team]["overtime losses"], standings[team]["losses"], standings[team]["goals for"], 
                                                   standings[team]["goals against"], standings[team]["points"]))
print("\n")

printstate(groupA)
printstate(groupB)
##21. 5.
print("Quaterfinals")
next_day()
next_day()
next_day()
##24. 5.
print("Semifinals")
next_day()
##25. 5.
print("Finals")
next_day()
print("And the winner is %s."% (Final.rank(0).position.team.name,))
##26. 5.




