from numpy.random import poisson, randint

class MatchSimulator:
    def __init__(self, teams):
        self._teams = teams
   
    def play(self, team1, team2):
        team1stats = self._teams.stats(team1)
        team2stats = self._teams.stats(team2)
        
        #stub matchgenerator
        def get_score(attack, defense):
            return poisson(3*attack/defense)        
        goals1 = get_score(team1stats["attack"], team1stats["defense"])
        goals2 = get_score(team2stats["attack"], team2stats["defense"])
        ret = {"teams": (team1, team2),
                      "goals": (goals1, goals2)}
        if goals1 == goals2:
            overtime_winner = randint(0,1)
            ret["overtime_winner"] = overtime_winner

        #printing here is prety bad, but it is 1AM
        pgoals1 = goals1
        pgoals2 = goals2
        pot=""
        if goals1 == goals2:
            pot="(ot)"
            if ret["overtime_winner"] == 0:
                pgoals1 += 1
            else:
                pgoals2 += 1
        print("%s - %s    %d:%d %s\n" % (team1, team2, pgoals1, pgoals2, pot))
        
        return ret
