class Teams:
    def __init__(self, teams):
        self._teams = {team.name : team for team in teams}

    def stats(self, teamname):
        return {"attack": self._teams[teamname].attack, 
                "defense": self._teams[teamname].defense}


class Team:
    def __init__(self, name, attack, defense):
        self._name = name
        self._attack = attack
        self._defense = defense
    @property
    def name(self):
        return self._name
    @property
    def attack(self):
        return self._attack
    @property
    def defense(self):
        return self._defense
