import unittest
from tournament.position_rank import Position, FilledPosition, Rank

StubTeam = str

class TestPositionRank(unittest.TestCase):
    def setUp(self):
        self.germany = StubTeam("Germany")
        self.slovakia = StubTeam("Slovakia")
        self.france = StubTeam("France")
        self.england = StubTeam("England")
        self.rank1 = Rank(True, FilledPosition(self.slovakia), "1")
        self.rank2 = Rank(False, FilledPosition(self.germany), "2")
        self.rank3 = Rank(False, FilledPosition(self.england), "3")
        self.position1 = Position(self.rank1)
        self.position2 = Position(self.rank2)
        self.position3 = FilledPosition(self.france)
        self.position4 = Position(self.rank3)

    def test_position_resolution(self):
        self.assertEqual(self.position1.team, self.slovakia)
        self.assertIsNone(self.position2.team)
        self.assertEqual(self.position3.team, self.france)

    def test_position_resolution_after_make_final(self):
        self.rank2.make_final()
        self.assertEqual(self.position2.team, self.germany)

    def test_you_cannot_change_ranks_position_if_it_is_final(self):
        self.assertRaises(AssertionError, setattr, self.rank1, "position",
                          FilledPosition(self.germany))

    def test_position_change(self):
        self.rank2.position = FilledPosition(self.england)
        self.rank3.position = FilledPosition(self.germany)
        self.rank2.make_final()
        self.assertEqual(self.position2.team, self.england)

    def test_rank_can_store_and_change_rankinfo(self):
        self.assertEqual(self.rank1.rankinfo, "1")
        self.rank1.rankinfo = "5"
        self.assertEqual(self.rank1.rankinfo, "5")

if __name__ == '__main__':
    unittest.main()
