###Ice hockey World Championship 2019

#####Architecture

This project follows the architectural decomposition from the Architecture lecture. Note that I do not plan to implement the project presented at the architecture lecture fully, thus I slightly simplified the interfaces as follows (I was lazy).

The interface between Tournament and MatchSimulator has just one method 
*play(team1, team2)*
where *team1* and *team2* are strings and it returns a map
*{"teams": (team1, team2), "goals": (goals1, goals2), "overtime_winner": winner}*
where *team1* and *team2* are strings, *goal1* and *goal2* are integers and *winner*
is 0 or 1. the field "overtime_winner" is present only if *goals1==goals2*.

The interface between MatchSimulator and Teams has just one method
*stats(team)*
which takes *team* as a string and returns a map containing its attack and defense.

Finally, the interface between the user interface and the other components contains 
just one method, *next_day()*.

The following components of the system are faked (we made an easy implementation instead of real one): 

- MatchSimulator: we provide a simple implementation that generates just goals
- Teams: Teams have no strategy, just attack and defense
- Tournament: The implementation of Ranking is faked, it just takes into account goal and points
- FIFARanking: No fake implementation is needed as Ranking is faked.

#####Design

As large parts of the system is mocked, no other interfaces are relevant. We use 
the model presented in the Modeling domain lecture. Considering implementation and 
testing we made one additional change. We separated the Ranking from PlayGroup 
as ranking is a complex tasks that requires separate and careful implementation
and testing. Note that as it is the code that implements Ranking is very ugly
and we should do better. We will show how things can be improved in the next lectures/

Note that there is very little dependence between the modules. This is the result of extensive use of dependency injection. Just playgroup depends on position_rank. We could eliminate this dependency, however we decided not to as the classes are very tightly related and it should be no problem to implement and test them together in practice. The cost of this flexibility is mostly in the complexity of constructing the objects. More on dependency injection in the future lectures.
