###Ordering teams in FIFA WC qualification 2018
odgering.pdf

This is an O-O solution to the problem. We decompose the problem to several smaller problems. This results to higher flexibility (we can handle rule changes easier in the future) and we are in a better position to thoroughly test our implementation.

You may spot composite and strategy patterns in the solution.

###Library and web-neweb-hra

These projects represent how to build a classes that extend other classes and how to separate concerns.  

library_mixed.py contains a mix of code implementing domain logic and logging. This is often the case with logging code. We decided to separate logging code and write it as an plug-in over the domain logic code. Note that this is not the way you do this normally - there is a variety of logging tools that (partially) solve these problems. 

To separate two concerns A and B either A uses B or vice-versa. Typically the situation is not symmetric as one of the concerns (typically the one representing domain logic) has more dependencies than other. As business logic often makes sense without DB, I/O, it is better if DB and I/A are built as a plugin, that is I/O class B uses domain logic class A (of course through an interface).

The attached diagram shows the two options. Note the necessity of a factory so that Reservation can create correct instances of ReservationInterface without being coupled to a specific implementation.

web-neweb-hra shows a simple game. Mixed folder contains an implementation where concerns are mixed. As of now it is simpler. But it is harder to add new features in it and it is much harder to test. We separated I/O and DB concerns. The flexibility we gained allows us to use the system without DB (even if you do not need it it is good for testing) and have both HTTP and console interfaces. 

