import unittest
from unittest.mock import Mock

#We test the confirming to the rank_function interface
#result = rank_function(teams, matches)
#teams - tuple of teams to rank. Team has a.name property + whatever ranking functions require
#matches - tuple of matches. Has .home.name for home team name and .away.name and can swap sides 
#          + whatever ranking functions require
#result - tuple of tuples of strings(team names)

#We are testing the following function
#compose_rank_functions(f1, f2)
#it takes two rank_functions and composes them, that is
#if two teams are equal in f1, then f2 decides. 

#this is not a full set of tests, we want just show mocking

class TestComposeRankFunctions(unittest.TestCase):    
    def setUp(self):
        self.teams=("Slovakia", "Germany", "France", "San Marino") 
        self.matches=()
        self.function1 = Mock()
        self.function2 = Mock()

    def test_upper(self):
        self.function1.return_value = (("Slovakia", "Germany", "France"), ("San Marino",)) 
        self.function2.return_value = (("Germany", "France"), ("Slovakia", "San Marino")) 
        res = compose_rank_functions(self.function1, self.function2)(self.teams, self.matches)
        self.assertEqual(res, (("Germany", "France"), ("Slovakia",), ("San Marino"))
        # + hardcore mockist may add
        #self.function1.assert_called_once_with ...
        #self.function2.assert_called_once_with ...
        #but I believe, that this couples the test with implementation a bit too much.

if __name__ == '__main__':
    unittest.main()
