import unittest
from library import Reservation


class TestReservation(unittest.TestCase):
    def setUp(self):
        self.r = Reservation(0, 10, "Dune", "Robert")

    def test_construction(self):        
        with self.assertRaises(ValueError):
            Reservation(2, 1, "Dune", "Zuzana")
        self.assertEqual(Reservation(1, 2, "Dune", "Zuzana").from_, 1)
        self.assertEqual(self.r.from_, 0)

    #reserve_book is not trivial at all, we should do at least some more involved test
    def test_overlapping(self):        
        self.assertTrue(self.r.overlapping(Reservation(0, 5, "Dune", "Zuzana")))
        self.assertTrue(self.r.overlapping(Reservation(-2, 0, "Dune", "Zuzana")))
        self.assertTrue(self.r.overlapping(Reservation(10, 20, "Dune", "Robert")))
        self.assertFalse(self.r.overlapping(Reservation(-2, -1, "Dune", "Robert")))
        self.assertFalse(self.r.overlapping(Reservation(11, 20, "Dune", "Robert")))
        self.assertFalse(self.r.overlapping(Reservation(1, 4, "Dune 2", "Robert")))
        self.assertFalse(self.r.overlapping(Reservation(11, 20, "Dune", "Zuzana")))

    def test_includes(self):        
        self.assertTrue(self.r.includes(0))
        self.assertTrue(self.r.includes(2))
        self.assertTrue(self.r.includes(10))
        self.assertFalse(self.r.includes(11))
        self.assertFalse(self.r.includes(-1))
 
    def test_identify(self):        
        self.assertEqual(self.r.identify(0, "Dune", "Robert"), "OK")
        self.assertEqual(self.r.identify(5, "Dune", "Robert"), "OK")
        self.assertEqual(self.r.identify(11, "Dune", "Robert"), "date")
        self.assertEqual(self.r.identify(-1, "Dune", "Robert"), "date")
        self.assertEqual(self.r.identify(10, "Dune 2", "Robert"), "book")
        self.assertEqual(self.r.identify(10, "Dune", "Zuzana"), "user")
        self.assertIn(self.r.identify(10, "Dune 2", "Zuzana"), {"user", "book"})
        self.assertIn(self.r.identify(12, "Dune", "Zuzana"), {"user", "date"})

    def test_change_for(self):
        self.r.change_for("Zuzana")     
        self.assertEqual(self.r.identify(0, "Dune", "Robert"), "user")
        self.assertEqual(self.r.identify(0, "Dune", "Zuzana"), "OK")
        self.assertEqual(self.r.identify(-1, "Dune", "Zuzana"), "date")
        self.assertEqual(self.r.identify(10, "Dune 2", "Zuzana"), "book")


if __name__ == '__main__':
    unittest.main()
        
