from library import Reservation, Library

#default method to handle the strings created is to print them
def stringprinter(str):
    print(str)


class ReservationLog(Reservation):    
    def __init__(self, from_, to, book, for_, printer=stringprinter):
        super().__init__(from_, to, book, for_)
        self._printer = printer
        self._printer(F'Created a reservation with id {self._id} of {self._book} '+
                     F'from {self._from} to {self._to} for {self._for}.')

    def overlapping(self, other):
        ret = super().overlapping(other)
        str = 'do'
        if not ret:
            str = 'do not'
        self._printer(F'Reservations {self._id} and {other._id} {str} overlap')
        return ret
            
    def includes(self, date):
        ret = super().includes(date)
        str = 'includes'
        if not ret:
            str = 'does not include'
        self._printer(F'Reservation {self._id} {str} {date}')
        return ret        
        
    def identify(self, date, book, for_):
        ret = super().identify(date, book, for_)
        if ret == 'book': 
            self._printer(F'Reservation {self._id} reserves {self._book} not {book}.')
        if ret == 'date':
            self._printer(F'Reservation {self._id} is for {self._for} not {for_}.')
        if ret == 'for':
            self.printer(F'Reservation {self._id} is from {self._from} to {self._to} which '+
                  F'does not include {date}.')
        if ret == 'OK':          
            self.printer(F'Reservation {self._id} is valid {for_} of {book} on {date}.')
        return ret
        
    def change_for(self, for_):
        self._printer(F'Reservation {self._id} moved from {self._for} to {for_}')
        super().change_for(for_)
        

class LibraryLog(Library):
    def __init__(self, res_factory=ReservationLog, printer=stringprinter):
        super().__init__(ReservationLog)
        self._printer = printer
        self._printer(F'Library created.')
                
    def add_user(self, name):
        ret = super().add_user(name)
        if ret:
            self._printer(F'User {name} created.')
        else:
            self._printer(F'User not created, user with name {name} already exists.')
        return ret

    def add_book(self, name):
        super().add_book(name)
        self._printer(F'Book {name} added. We have {self._books[name]} coppies of the book.')

    def reserve_book(self, user, book, date_from, date_to):
        res = super().reserve_book(user, book, date_from, date_to)
        if res == 'user':
            self._printer(F'We cannot reserve book {book} for {user} from {date_from} '+
                         F'to {date_to}. User does not exist.')
        if res == 'dates':
            self._printer(F'We cannot reserve book {book} for {user} from {date_from} '+
                         F'to {date_to}. Incorrect dates.')
        if res == 'nobook':
            self._printer(F'We cannot reserve book {book} for {user} from {date_from} '+
                         F'to {date_to}. We do not have that book.')
        if res == 'fully booked':
            self._printer(F'We cannot reserve book {book} for {user} from {date_from} '+
                         F'to {date_to}. We do not have enough books.')
        if res == 'OK':
            self._printer(F'Reservation {desired_reservation._id} included.')
        return res

    def check_reservation(self, user, book, date):
        res = super().check_reservation(user, book, date)
        str = 'exists'
        if not res:
            str = 'does not exist'
        self._printer(F'Reservation for {user} of {book} on {date} {str}.')
        return res        

    def change_reservation(self, user, book, date, new_user):
        res = super().change_reservation(user, book, date, new_user)
        if res == 'reservation':
            self._printer(F'Reservation for {user} of {book} on {date} does not exist.')
        if res == 'user':
            self._printer(F'Cannot change the reservation as {new_user} does not exist.')
        if res == 'OK':
            self._printer(F'Reservation for {user} of {book} on {date} '+
                         F'changed to {new_user}.')        
        return res
        
