import unittest
from library_logs import ReservationLog, LibraryLog



class TestReservationLibraryLog(unittest.TestCase):
    #Instead of printing we spy what should be printed
    def r_printer(self, stuff):
        self.r_messages += [stuff]
    def l_printer(self, stuff):
        self.l_messages += [stuff]

    def setUp(self):
        self.r_messages = []
        self.r = ReservationLog(0, 10, "Dune", "Robert", lambda x: self.r_printer(x))
        self.assertRegex(self.r_messages[0], 'Created a reservation with id [0-9]* of Dune '+
                     'from 0 to 10 for Robert.')   
        self.l_messages = []
        self.lib = LibraryLog(ReservationLog, lambda x: self.l_printer(x))
        self.assertEqual(self.l_messages[0], 'Library created.')

    def test_reservation_log(self):
        self.r.includes(5) 
        self.assertRegex(self.r_messages[1], 'Reservation [0-9]* includes 5')

    def test_library_log(self):
        self.lib.add_user("Robert")
        self.assertEqual(self.l_messages[1], 'User Robert created.')


if __name__ == '__main__':
    unittest.main()
        
