import asyncio
import time

import aiohttp
from aiohttp import web

from .sync_context import SyncContext


async def ok_handler(req):
    return web.Response()


async def ok_server(listen_addr):
    server = web.Server(ok_handler)
    runner = web.ServerRunner(server)
    await runner.setup()
    host, port = listen_addr
    site = web.TCPSite(runner, host, port)
    await site.start()
    print("Running")


async def incr_requester(i, y, target):
    val = 1
    start_time = time.perf_counter_ns()
    async with aiohttp.ClientSession() as session:
        for _ in range(y):
            data = {"id": i + 1, "val": val}
            async with session.post(target, json=data) as resp:
                val = (await resp.json())["val"]

    return time.perf_counter_ns() - start_time


async def process_a(sync: SyncContext, x, y, listen_addr, target_url):
    await ok_server(listen_addr)

    sync.sem_ok.release()

    await asyncio.get_event_loop().run_in_executor(None, sync.sem_incr.acquire)

    coros = []
    for i in range(x):
        coros.append(incr_requester(i, y, target_url))

    time = sum(await asyncio.gather(*coros))
    print("A done")
    sync.sem_done.release()
    return time


def process_a_wrapper(sync: SyncContext, x, y, listen_addr, target_url):
    loop = asyncio.get_event_loop()
    time = loop.run_until_complete(process_a(sync, x, y, listen_addr, target_url))
    sync.time.value = time
