import asyncio

import aiohttp
from aiohttp import web

from .sync_context import SyncContext


def make_incr_handler(session):
    async def incr_handler(req):
        async with session.get("http://localhost:1234/") as resp:
            assert resp.status == 200
        req_json = await req.json()
        ret = req_json["val"] + 1
        return web.json_response({"val": ret})

    return incr_handler


async def incr_server(session):
    server = web.Server(make_incr_handler(session))
    runner = web.ServerRunner(server)
    await runner.setup()
    site = web.TCPSite(runner, "localhost", 1235)
    await site.start()


async def process_b(sync: SyncContext, listen_addr, target_url):
    async with aiohttp.ClientSession() as session:
        await incr_server(session)
        sync.sem_incr.release()
        await asyncio.get_event_loop().run_in_executor(None, sync.sem_done.acquire)
        print("B done")


def process_b_wrapper(sync: SyncContext, listen_addr, target_url):
    sync.sem_ok.acquire()

    loop = asyncio.get_event_loop()
    loop.run_until_complete(process_b(sync, listen_addr, target_url))
