from multiprocessing import Process

from .process_a import process_a
from .process_b import process_b
from .sync_context import SyncContext

X = 10
Y = 1000

sync = SyncContext()

proc_a = Process(
    target=process_a, args=(sync, X, Y, ("127.0.0.1", 1234), "http://127.0.0.1:1235/")
)
proc_a.start()

proc_b = Process(
    target=process_b, args=(sync, ("127.0.0.1", 1235), "http://127.0.0.1:1234/")
)
proc_b.start()

proc_a.join()
proc_b.join()

print("Total time:", sync.time.value / 10e9)
