import json
import time
import urllib.parse
import urllib.request
from http.server import BaseHTTPRequestHandler, HTTPServer
from threading import Thread

from .sync_context import SyncContext


class OKHandler(BaseHTTPRequestHandler):
    def do_GET(self):
        self.send_response(200)
        self.end_headers()
    def log_request(self, *args, **kwargs):
        pass


def run_incr_requester(times, i, y, target):
    val = 1
    start_time = time.perf_counter_ns()

    for _ in range(y):
        data = json.dumps({"id": i + 1, "val": val}).encode("utf-8")
        req = urllib.request.Request(
            target, data, headers={"Content-Type": "application/json"}
        )

        with urllib.request.urlopen(req) as f:
            val = int(f.readline().decode("ascii"))

    times[i] = time.perf_counter_ns() - start_time


def process_a(sync: SyncContext, x, y, listen_addr, target_url):
    server = HTTPServer(listen_addr, OKHandler)
    ok_thread = Thread(target=server.serve_forever)
    ok_thread.start()

    print("ok server running")
    sync.sem_ok.release()
    print("waiting for incr server")
    sync.sem_incr.acquire()

    req_threads = []
    times = [0] * x
    for i in range(x):
        t = Thread(target=run_incr_requester, args=(times, i, y, target_url))
        req_threads.append(t)
        t.start()

    for t in req_threads:
        t.join()

    sync.time.value = sum(times)

    server.shutdown()
    ok_thread.join()

    sync.sem_done.release()
    print("A done")


if __name__ == "__main__":
    process_a()
