import json
import urllib.error
import urllib.request
from http.server import BaseHTTPRequestHandler, ThreadingHTTPServer
from threading import Thread

from .sync_context import SyncContext


def make_incr_handler(target_url):
    class IncrHandler(BaseHTTPRequestHandler):
        def do_POST(self):
            reqtype = self.headers["Content-Type"]
            if reqtype != "application/json":
                self.send_response(400)
                self.end_headers()
                return

            length = int(self.headers["Content-Length"])
            reqdata = self.rfile.read(length).decode("utf-8")
            reqjson = json.loads(reqdata)
            ret = reqjson["val"] + 1

            try:
                resp = urllib.request.urlopen(target_url)
                if resp.status != 200:
                    self.send_response(500)
                    self.end_headers()
                    return
            except urllib.error.URLError:
                self.send_response(500)
                self.end_headers()
                return

            self.send_response(200)
            self.end_headers()

            self.wfile.write(f"{ret}\n".encode("ascii"))
        def log_request(self, *args, **kwargs):
            pass

    return IncrHandler


def process_b(sync: SyncContext, listen_addr, target_url):
    print("waiting for ok server")
    sync.sem_ok.acquire()

    server = ThreadingHTTPServer(listen_addr, make_incr_handler(target_url))
    server_thread = Thread(target=server.serve_forever)
    server_thread.start()

    print("incr server running")
    sync.sem_incr.release()

    sync.sem_done.acquire()
    server.shutdown()
    server_thread.join()
    print("B done")


if __name__ == "__main__":
    process_b()
