import aiohttp
from aiohttp import web
import asyncio
import concurrent.futures
import multiprocessing as mp
from constants import *


class ATask:
    def __init__(self, task_id, session):
        self.task_id = task_id
        self.session = session

    async def run(self):
        i = 0
        for _ in range(Y):
            url = f'http://localhost:{B_PORT}'
            data = {'task_id': self.task_id, 'i': i}
            async with self.session.post(url, json=data) as r:
                response = await r.json()
                assert response['task_id'] == self.task_id
                i = response['i']
        assert i == Y


class A:
    async def handle_ok(self, request):
        return web.Response()

    async def run(self):
        async with aiohttp.ClientSession() as session:
            self.session = session

            app = web.Application()
            app.add_routes([web.post('/', self.handle_ok)])
            runner = web.AppRunner(app)
            await runner.setup()
            site = web.TCPSite(runner, '', A_PORT)
            asyncio.create_task(site.start())

            b_ready.wait()  # this is blocking, but it's ok, process A needs to wait here
            tasks = (ATask(task_id, session).run() for task_id in range(X))
            await asyncio.gather(*tasks)

            await runner.cleanup()
            a_done.set()


class B:
    async def handle_inc(self, request):
        async with self.session.get(f'http://localhost:{A_PORT}') as r:
            await r.text()
        data = await request.json()
        data['i'] += 1
        return web.json_response(data)

    async def run(self):
        async with aiohttp.ClientSession() as session:
            self.session = session

            app = web.Application()
            app.add_routes([web.post('/', self.handle_inc)])
            runner = web.AppRunner(app)
            await runner.setup()
            site = web.TCPSite(runner, '', B_PORT)
            asyncio.create_task(site.start())
            b_ready.set()

            # mp.Event.wait() is blocking (but we want the server to be available) - we need to run
            # event.wait() in another thread
            with concurrent.futures.ThreadPoolExecutor() as pool:
                loop = asyncio.get_running_loop()
                await loop.run_in_executor(pool, a_done.wait)

            await runner.cleanup()


# these are global (we could pass them to A(), B() constructors, but let's keep it simple)
b_ready = mp.Event()
a_done = mp.Event()

a = mp.Process(target=lambda: asyncio.run(A().run()))
b = mp.Process(target=lambda: asyncio.run(B().run()))
a.start()
b.start()
a.join()
b.join()
