from pyrsistent import pmap, pset

#you may want to use PClass, but we want to learn something
class Graph:
    def __init__(self, _incidence = pmap()):
        self._incidence = _incidence #pmap<int,pset<int>>
    
    def _maybemakenew(self, incidence):
        if incidence == self._incidence: return self
        return Graph(incidence)
                    
    def hasvertex(self, v):
        return v in self._incidence
                    
    def hasedge(self, v1, v2):
        return v1 in self._incidence and v2 in self._incidence[v1]
        
    def vertices(self):
        for el in self._incidence:
            yield el

    def neighbours(self, v):
        if v not in self._incidence: return
        for el in self._incidence[v]:
            yield el

    def _dostuffwithedge(self, v1, v2, fun):
        modifyv1 = fun(v1)
        modifyv2 = fun(v2)
        newinc = self._incidence.transform([v1], modifyv2, [v2], modifyv1)
        return self._maybemakenew(newinc)
            
    def addvertex(self, v):
        if v in self._incidence: return self
        return Graph(self._incidence.set(v, pset()))

    def addedge(self, v1, v2):
        if self.hasedge(v1, v2): return self
        return self._dostuffwithedge(v1, v2, lambda v: (lambda x: x.add(v)))
                    
    def removeedge(self, v1, v2):
        if not self.hasedge(v1, v2): return self
        return self._dostuffwithedge(v1, v2, lambda v: (lambda x: x.remove(v)))
        
    def removevertex(self, v):
        if v not in self._incidence: return self
        evo = self._incidence.evolver()
        for v2 in self._incidence[v]:
            evo[v2] = evo[v2].remove(v)
        evo.remove(v)
        return Graph(evo.persistent())