from graph import Graph

def test_addvertex(G):
    g1 = G()
    assert(g1.hasvertex(1) is False)
    g2 = g1.addvertex(1)
    assert(g2.hasvertex(1) is True)
    assert(g1.hasvertex(1) is False)
    g3 = g2.addvertex(1)
    assert(g3 == g2)
    g4 = g3.addvertex(2)
    assert(g1.hasvertex(4) is False)
    assert(set(g1.vertices()) == set())
    assert(set(g3.vertices()) == set({1}))
    assert(set(g4.vertices()) == set({1, 2}))
    
def test_addedge(G):
    g1 = G().addvertex(1).addvertex(2).addvertex(3).addedge(1, 2)
    assert(g1.hasedge(1, 2))
    assert(g1.hasedge(2, 1))
    assert(not g1.hasedge(2, 3))
    assert(not g1.hasedge(4, 5))
    g2 = g1.addedge(1,2)
    assert(g2 == g1)
    g2 = g1.addedge(2,1)
    assert(g2 == g1)
    g3 = g2.addedge(3, 2)
    assert(set(g1.neighbours(3)) == set())
    assert(set(g3.neighbours(1)) == set({2}))
    assert(set(g3.neighbours(2)) == set({1, 3}))
    
def test_removevertex(G):
    g1 = G().addvertex(1).addvertex(2).addvertex(3).addedge(1, 2).addedge(2, 3)
    assert(g1.removevertex(4) == g1)
    g2 = g1.removevertex(2)
    assert(set(g2.vertices()) == set({1, 3}))
    assert(not g2.hasedge(1, 2))
    assert(not g2.hasedge(2, 1))

def test_removeedge(G):
    g1 = G().addvertex(1).addvertex(2).addvertex(3).addedge(1, 2).addedge(2, 3)
    assert(g1.removeedge(1, 3) == g1)
    g2 = g1.removeedge(1, 2)
    assert(not g2.hasedge(1, 2))
    assert(not g2.hasedge(1, 2))
    assert(g2.hasedge(3, 2))



if __name__ == "__main__":
    test_addvertex(Graph)
    test_addedge(Graph)
    test_removevertex(Graph)
    test_removeedge(Graph)
    print("Tests complete.")