from labeled_graph import LabeledGraph
from pyrsistent import v, inc

def test_vertextransform():
    g1 = LabeledGraph().addvertex(1).addvertex(2).addvertex(3).addedge(1, 2).addedge(2, 3) \
                       .setvertexlabel(1, v(1, 2, 3)).setvertexlabel(2, v(2, 3)) \
                       .setedgelabel(1, 2, v(9, 8)).setedgelabel(2, 3, v())
    assert(g1.transform([{1}, 0], 5)[{1}][0] == 5)
    assert(g1.transform([{1}, 0], 1) == g1)
    assert(g1.transform([{3}, 0], 5)[{3}][0] == 5)
    assert(g1.transform([{1, 2}, 0], 5)[{1, 2}][0] == 5)
    assert(g1.transform([{1, 2}, 0], 9) == g1)
    assert(g1.transform([{2, 3}, 0], 5)[{2, 3}][0] == 5)

def test_vertextransform2():
    g1 = LabeledGraph().addvertex(1).addvertex(5).addedge(1, 5).setvertexlabel(1, 101)
    g2 = LabeledGraph().addvertex(4).addvertex(5).addedge(4, 5).setedgelabel(4, 5, 45)
    g3 = LabeledGraph().addvertex(7).addvertex(8).addedge(7, 8) \
                       .setvertexlabel(8, g1).setvertexlabel(7, g1).setedgelabel(7, 8, g2)
    assert(g3.transform([{8}, {1}], inc)[{8}][{1}] == 102)
    assert(g3.transform([{7, 8}, {5, 4}], inc)[{8, 7}][{4, 5}] == 46)

    assert(g3.transform([{8}, {2}], 1)[{8}][{2}] == 1)
    
    def only_odd_vertices(idx):
        return len(idx) == 1 and next(iter(idx))%2 == 0   
    g4 = g3.transform([only_odd_vertices, {5}], 7)
    assert(g4[{8}][{5}] == 7)
    assert(not g4[{7}].hasvertexlabel(5))
    assert(not g4[{7, 8}].hasvertexlabel(5))

    def all_edges(idx):
        return len(idx) == 2
    g5 = g3.transform([all_edges, {5}], 7)
    assert(not g5[{7}].hasvertexlabel(5))
    assert(g5[{7, 8}][{5}]==7)

        
   
if __name__ == "__main__":
    test_vertextransform()
    test_vertextransform2()
    print("Tests complete.")