#We connect to database and start a session
from sqlalchemy import create_engine
from sqlalchemy.orm import sessionmaker
from orm import my_database, MyBase
engine = create_engine(my_database, echo=False)

session = sessionmaker(bind=engine)()

from library import Library
from library_persist import LibraryUsersPerVer1, LibraryUsersPerVer2, LibraryBooksPer, LibraryReservationsPer, ReservationPer, ReservationFactory

lib = Library(LibraryUsersPerVer2(session), LibraryBooksPer(session), LibraryReservationsPer(session), ReservationFactory)


assert(lib.add_user("Robert") is True)
assert(lib.add_user("Robert") is False)
assert(lib.add_user("Zuzka") is True)

lib.add_book("Dune")
lib.add_book("Dune")
lib.add_book("Dune 2")

assert(lib.reserve_book("Robert", "Dune", 1, 12) == "OK")
assert(lib.reserve_book("Zuzka", "Dune", 4, 12) == "OK")
assert(lib.reserve_book("Robert", "Dune", 5, 12) == "fully booked")
session.commit()

#########################################################

lib.add_book("Dune")
assert(lib.check_reservation("Zuzka", "Dune", 1) == False)
assert(lib.check_reservation("Zuzka", "Dune", 4) == True)
assert(lib.add_user("Zinka") is True)
assert(lib.reserve_book("Zinka", "Dune", 5, 12) == "OK")
assert(lib.reserve_book("Robert", "Dune", 2, 12) == "fully booked")

session.commit()

#########################################################

assert(lib.add_user("Emilka") is True)
assert(lib.check_reservation("Zinka", "Dune", 7) == True)
assert(lib.change_reservation("Zinka", "Dune", 7, "Emilka") == "OK")
assert(lib.check_reservation("Emilka", "Dune", 7) == True)
assert(lib.check_reservation("Zinka", "Dune", 7) == False)
