import random
from dataclasses import dataclass
from typing import List

from cardgame.abc.CardABC import CardABC


@dataclass
class Card(CardABC):
    SUITS = list("♠♥♦♣")
    RANKS = [*"23456789", "10", *"JQKA"]

    suit: str
    rank: int  # Store rank as index for easier comparison

    def __str__(self) -> str:
        return f"[{self.RANKS[self.rank]}{self.suit}]"

    def __ge__(self, other: CardABC) -> bool:
        if not isinstance(other, Card):
            raise TypeError(f"Cannot compare Card with {type(other)}")
        return self.rank >= other.rank

    @classmethod
    def get_random_card(cls) -> "Card":
        return cls(
            suit=random.choice(cls.SUITS), rank=random.randint(0, len(cls.RANKS) - 1)
        )

    @classmethod
    def get_all_cards(cls) -> List["CardABC"]:
        return [Card(s, r) for s in cls.SUITS for r in range(len(cls.RANKS))]
