from typing import Dict, Tuple, Type

from cardgame.abc.CardABC import CardABC
from cardgame.abc.DealerABC import DealerABC
from cardgame.abc.DealerFactoryABC import DealerFactoryABC
from cardgame.abc.GameABC import GameABC
from cardgame.abc.HandABC import HandABC
from cardgame.abc.TrickABC import TrickABC
from cardgame.abc.WinnerStrategyABC import WinnerStrategyABC
from cardgame.Card import Card
from cardgame.DealerGeneric import DealerGeneric
from cardgame.Game import Game
from cardgame.GameType import GameType
from cardgame.Hand import Hand
from cardgame.SetCard import SetCard
from cardgame.Trick import Trick
from cardgame.WinnerStrategyFirst import WinnerStrategyFirst
from cardgame.WinnerStrategyLast import WinnerStrategyLast


class DealerFactory(DealerFactoryABC):
    TYPES: Dict[
        GameType,
        Tuple[
            str,
            Type[GameABC],
            Type[HandABC],
            Type[CardABC],
            Type[TrickABC],
            Type[WinnerStrategyABC],
        ],
    ] = {
        GameType.Standard: (
            str(GameType.Standard),
            Game,
            Hand,
            Card,
            Trick,
            WinnerStrategyLast,
        ),
        GameType.FirstWin: (
            str(GameType.FirstWin),
            Game,
            Hand,
            Card,
            Trick,
            WinnerStrategyFirst,
        ),
        GameType.SetGame: (
            str(GameType.SetGame),
            Game,
            Hand,
            SetCard,
            Trick,
            WinnerStrategyLast,
        ),
    }

    @staticmethod
    def get_dealer(game_type: GameType) -> DealerABC:
        return DealerGeneric(*DealerFactory.TYPES[game_type])
