from typing import Optional, Type

from cardgame.abc.GameABC import GameABC
from cardgame.abc.GameServerABC import GameServerABC
from cardgame.abc.GameStateABC import GameStateABC
from cardgame.abc.DealerFactoryABC import DealerFactoryABC
from cardgame.DealerFactory import DealerFactory
from cardgame.GameType import GameType


class NotInGameException(Exception):
    """No Game is currently running"""

    pass


class GameServer(GameServerABC):
    game: Optional[GameABC]

    def __init__(self, dealer_factory: DealerFactoryABC=DealerFactory()) -> None:
        self.dealer_factory=dealer_factory
        self.game = None

    def play(self, player: int, card_number: int) -> bool:
        if self.game is None:
            raise NotInGameException()
        return self.game.play(player, card_number)

    def get_state(self, player: int) -> GameStateABC:
        if self.game is None:
            raise NotInGameException()
        return self.game.state().player_view(player)

    def new_game(
        self, game_type: GameType = GameType.Standard, player_count: int = 4
    ) -> bool:
        self.game = self.dealer_factory.get_dealer(game_type).create_game(player_count)
        return True
