from dataclasses import dataclass
from typing import List, Optional

from cardgame.abc.CardABC import CardABC
from cardgame.abc.GameStateABC import GameStateABC


@dataclass
class GameState(GameStateABC):
    cards: List[Optional[List[CardABC]]]
    trick: List[CardABC]

    def player_view(self, player: int) -> "GameState":
        n = len(self.cards)
        return GameState(
            cards=[self.cards[player]] + [None] * (n - 1), trick=self.trick
        )
