from typing import List, Sequence

from cardgame.abc.CardABC import CardABC
from cardgame.abc.HandABC import HandABC
from cardgame.abc.TrickABC import TrickABC


class Hand(HandABC):
    _player: int
    _cards: List[CardABC]
    _trick: TrickABC

    def __init__(self, player: int, trick: TrickABC, cards: Sequence[CardABC]):
        self._player = player
        self._trick = trick
        self._cards = list(cards)

    def play(self, card_number: int) -> bool:
        if not 0 <= card_number < len(self._cards):
            return False
        ret = self._trick.play_normal(self._player, self._cards[card_number])
        if not ret and self.is_lowest(card_number):
            # Could not play the card normally, but it is the lowest card on-hand,
            # play it as lowest.
            ret = self._trick.play_as_lowest(self._player, self._cards[card_number])
        if ret:
            # Remove card if it was played successfully
            self._cards = self._cards[:card_number] + self._cards[card_number + 1 :]
        return ret

    def is_lowest(self, card_number: int) -> bool:
        card = self._cards[card_number]
        for c in self._cards:
            if card >= c and not c >= card:
                return False
        return True

    def cards(self) -> List[CardABC]:
        # TODO immutable?
        return self._cards
